#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

struct Tacka {
    long long x, y;
    bool operator<(const Tacka& other) const {
        return x < other.x || (x == other.x && y < other.y);
    }
};

long long proizvod_kr(const Tacka& O, const Tacka& A, const Tacka& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

long long povrsina_poligona(const vector<Tacka>& tacka) {
    long long povrsina = 0;
    int n = tacka.size();
    for (int i = 0; i < n; ++i) {
        int j = (i + 1) % n;
        povrsina += tacka[i].x * tacka[j].y - tacka[j].x * tacka[i].y;
    }
    return abs(povrsina) / 2;
}

vector<Tacka> konveksni_omotac(vector<Tacka>& tacka) {
    sort(tacka.begin(), tacka.end());

    vector<Tacka> donji, gornji;

    for (const auto& t : tacka) {
        while (donji.size() >= 2 && proizvod_kr(donji[donji.size() - 2], donji[donji.size() - 1], t) <= 0) {
            donji.pop_back();
        }
        donji.push_back(t);
    }

    for (int i = tacka.size() - 1; i >= 0; --i) {
        while (gornji.size() >= 2 && proizvod_kr(gornji[gornji.size() - 2], gornji[gornji.size() - 1], tacka[i]) <= 0) {
            gornji.pop_back();
        }
        gornji.push_back(tacka[i]);
    }

    donji.pop_back();
    gornji.pop_back();
    donji.insert(donji.end(), gornji.begin(), gornji.end());

    return donji;
}

long long povrsina_konveksnog_skoro_omotaca(vector<Tacka>& tacka, int izostavi) {
    vector<Tacka> nove_tacka;

    for (int i = 0; i < tacka.size(); ++i) {
        if (i != izostavi) {
            nove_tacka.push_back(tacka[i]);
        }
    }

    vector<Tacka> omotac = konveksni_omotac(nove_tacka);

    return povrsina_poligona(omotac);
}

int main() {
    int N;
    cin >> N;
    vector<Tacka> tacka(N);

    for (int i = 0; i < N; ++i) {
        cin >> tacka[i].x >> tacka[i].y;
    }

    long long min_povrsina = LLONG_MAX;

    for (int i = 0; i < N; ++i) {
        min_povrsina = min(min_povrsina, povrsina_konveksnog_skoro_omotaca(tacka, i));
    }

    cout << min_povrsina << endl;

    return 0;
}